﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Chapter_05
{
    class Program
    {
        static void Main(string[] args)
        {
            int intResult;
            string strResult;
            string str1 = "łańcuch 1";
            string str2 = "[łańcuch 2]";

            // łańcuchy formatujące

            string formatString = "{0,15}";

            strResult = string.Format(formatString, str2);

            Console.WriteLine("string.Format({0}, {1}) = {2}\n",
              formatString, str2, strResult);

            formatString = "{0,-15}";

            strResult = string.Format(formatString, str2);

            Console.WriteLine("string.Format({0}, {1}) = {2}\n",
              formatString, str2, strResult);

            strResult = string.Format("Waluta: {0:C}, Hex: '{0,2:X}'", 10);
            Console.WriteLine(strResult);

            strResult = string.Format("Własne formatowanie waluty: {0:#,###.00 zł}", 123456);
            Console.WriteLine(strResult);

            strResult = string.Format("Warunkowe formatowanie waluty: {0:#,###.00 zł;(#,###.00 zł);0.00 zł}", -123456);
            Console.WriteLine(strResult);


            
            // porównywanie łańcuchów
            str2 = "łańcuch 2";

            intResult = String.Compare(str1, str2);

            Console.WriteLine("String.Compare({0}, {1}) = {2}\n",
              str1, str2, intResult);

            intResult = String.CompareOrdinal(str2, str1);

            Console.WriteLine("String.CompareOrdinal({0}, {1}) = {2}\n",
              str2, str1, intResult);

            intResult = str1.CompareTo(str2);

            Console.WriteLine("{0}.CompareTo({1}) = {2}\n",
              str1, str2, intResult);

            // sprawdzanie warunku równości łańcuchów

            bool boolResult = str1 == str2;

            Console.WriteLine("boolResult: {0}", boolResult);

            boolResult = String.Equals(str1, str2);

            Console.WriteLine("String.Equals({0}, {1}) = {2}\n",
              str1, str2, boolResult);

            boolResult = str1.Equals(str2);

            Console.WriteLine("{0}.Equals({1}) = {2}\n",
              str1, str2, boolResult);

            // łączenie łańcuchów

            strResult = str1 + ", " + str2;

            Console.WriteLine(strResult);
            Console.WriteLine("{0}, {1}", str1, str2);
            Console.WriteLine(str1 + ", " + str2);

            strResult = String.Concat(str1, str2);

            Console.WriteLine("String.Concat({0}, {1}) = {2}\n",
              str1, str2, strResult);

            // kopiowanie łańcuchów

            strResult = String.Copy(str1);

            bool equal = object.ReferenceEquals(strResult, str1);

            Console.WriteLine("String.Copy({0}) = {1}\n",
              str1, strResult);

            strResult = str1;

            equal = object.ReferenceEquals(strResult, str1);

            char[] charArr = new char[str1.Length];

            str1.CopyTo(0, charArr, 0, str1.Length);

            Console.WriteLine(
              "{0}.CopyTo(0, charArr, 0, str1.Length) = ",
              str1);

            foreach (char character in charArr)
            {
                Console.Write("{0} ", character);
            }
            Console.WriteLine("\n");

            strResult = (string)str1.Clone();

            Console.WriteLine("(string){0}.Clone() = {1}\n",
              str1, strResult);

            equal = object.ReferenceEquals(strResult, str1);

            // sprawdzanie zawartości łańcucha

            boolResult = str1.StartsWith("Łań");

            Console.WriteLine("str1.StartsWith(\"Łań\"): {0}",
              boolResult);

            boolResult = str1.Contains("cuch");

            Console.WriteLine("str1.Contains(\"cuch\"): {0}", 
                boolResult);

            // wyodrębnianie informacji z łańcucha

            intResult = str1.IndexOf('1');

            Console.WriteLine("str1.IndexOf('1'): {0}", intResult);

            string filePath = @"c:\Windows\Microsoft.NET\Framework\v3.5.x.x\csc.exe";
            intResult = filePath.LastIndexOf(@"\");
            Console.WriteLine("filePath.LastIndexOf(@\"\\\"): {0}", intResult);

            strResult = str1.Substring(str1.IndexOf("cuch"), 4);
            Console.WriteLine("str1.Substring(str1.IndexOf(\"cuch\"), 4) : {0}", 
                strResult);

            // wyrównywanie i przycinanie wyjściowego łańcucha

            strResult = str1.PadLeft(15);

            Console.WriteLine("str1.PadLeft(15): [{0}]",
              strResult);

            strResult = str1.PadRight(15, '*');

            Console.WriteLine("str1.PadRight(15, '*'): [{0}]",
              strResult);

            string trimString = " [ znakiwidoczne] ";

            strResult = trimString.Trim();

            Console.WriteLine("trimString.Trim(): [{0}]",
              strResult);

            strResult = trimString.TrimEnd(new char[] { ' ' });

            Console.WriteLine("trimString.TrimEnd(): [{0}]",
              strResult);

            strResult = trimString.TrimStart(new char[] { ' ' });

            Console.WriteLine("trimString.TrimStart(): [{0}]",
              strResult);

            // modyfikacja zawartości łańcucha

            strResult = str2.Insert(7, "1");

            Console.WriteLine("str2.Insert(7, \"1\"): {0}",
              strResult);

            strResult = str2.Remove(4, 3);

            Console.WriteLine("str2.Remove(4, 3): {0}",
              strResult);

            string ucString = "ŁańcuchZWielkimiLiterami";

            strResult = ucString.ToLower();

            Console.WriteLine("ucString.ToLower(): {0}",
              strResult);

            strResult = str1.ToUpper();

            Console.WriteLine("str1.ToUpper(): {0}",
              strResult);

            // dzielenie i łączenie łańcuchów

            string csvString = "jeden,dwa,trzy";

            string[] stringArray = csvString.Split(new char[] { ',' });

            foreach (string strItem in stringArray)
            {
                Console.WriteLine("Element: {0}", strItem);
            }

            string[] strArr = new string[] { str1, str2 };

            strResult = string.Join(",", strArr);

            Console.WriteLine(
              "string.Join(\",\", [str1 i str2]) = {0}\n",
              strResult);

            // operacje na znakach łańcucha

            intResult = str1.Length;

            Console.WriteLine("str1.Length: {0}",
              intResult);

            char charResult = str1[3];

            Console.WriteLine("str1[3]: {0}",
              charResult);

            for (int i = 0; i < str1.Length; i++)
            {
                Console.WriteLine("str1[{0}]: {1}", i, str1[i]);
            }

            char[] characterArray = str1.ToCharArray();

            foreach (char character in charArr)
            {
                Console.WriteLine("char: {0}", character);
            }

            // pula wewnętrzna łańcuchów

            string objStr1 = string.Concat("łańcuch ", "1");
            string internedStr1 = string.Intern(objStr1);

            Console.WriteLine(
              "(object)objStr1 == (object)str1 is {0}\n",
              ((object)objStr1 == (object)str1));

            Console.WriteLine(
              "(object)internedStr1 == (object)str1 is {0}\n",
              ((object)internedStr1 == (object)str1));

            strResult = string.IsInterned(internedStr1);

            Console.WriteLine("string.IsInterned({0}) = {1}\n",
              internedStr1, strResult);

            // klasa StringBuilder

            StringBuilder myStringBuilder;
            myStringBuilder = new StringBuilder("Pierwotny");

            myStringBuilder.Append("Dołączony");

            Console.WriteLine(
              "myStringBuilder.Append(\"Dołączony\"): {0}",
              myStringBuilder);

            myStringBuilder = new StringBuilder("Pierwotny");

            myStringBuilder.AppendFormat("{0,9}", "Dołączony");

            Console.WriteLine(
            "myStringBuilder.AppendFormat(\"{0,9}\",\"Dołączony\"): {0}",
            myStringBuilder);

            int capacity;
            myStringBuilder = new StringBuilder();

            capacity = myStringBuilder.EnsureCapacity(129);

            Console.WriteLine(
              "myStringBuilder.EnsureCapacity(129): {0}",
              myStringBuilder.Capacity);

            // wyrażenia regularne

            string zip = "1234C";
            bool isGoodZip = true;

            foreach (char ch in zip)
            {
                if (!char.IsDigit(ch))
                {
                    isGoodZip = false;
                    break;
                }
            }

            //string searchString = "1234C";
            //string regExString = @"\d\d\d\d\d";
            //string searchString = "12345-6789";
            string searchString = "";
            //string regExString = @"\d\d\d\d\d-\d\d\d\d";
            //string regExString = @"\d{5}-\d{4}";
            string regExString = @"\d+";

            Regex rex = new Regex(regExString);
            bool isMatch = rex.IsMatch(searchString);
            
            Console.WriteLine("isMatch: {0}", isMatch);
            
            Console.ReadKey();
        }
    }
}
